import React from "react";
import * as Tooltip from "@radix-ui/react-tooltip";
import { HelpCircle } from "lucide-react";

interface InfoIconProps {
  tooltip: string;
}

export default function InfoIcon({ tooltip }: InfoIconProps) {
  const [open, setOpen] = React.useState(false);

  return (
    <Tooltip.Provider delayDuration={300}>
      <Tooltip.Root open={open} onOpenChange={setOpen}>
        <Tooltip.Trigger asChild>
          <button
            className='cursor-help ml-1 touch-manipulation'
            onClick={(e) => {
              e.stopPropagation();
              setOpen(!open);
            }}
          >
            <HelpCircle className='w-4 h-4 text-gray-400 hover:text-gray-600 active:text-gray-700' />
          </button>
        </Tooltip.Trigger>
        <Tooltip.Portal>
          <Tooltip.Content
            className='z-50 px-2 sm:px-3 py-2 text-xs sm:text-sm text-white bg-gray-900 rounded-lg shadow-lg max-w-[280px] sm:max-w-xs'
            sideOffset={5}
            side='top'
            align='end'
            onPointerDownOutside={() => setOpen(false)}
          >
            <div className='max-h-[60vh] sm:max-h-none overflow-y-auto'>
              {tooltip}
            </div>
            <Tooltip.Arrow className='fill-gray-900' />
          </Tooltip.Content>
        </Tooltip.Portal>
      </Tooltip.Root>
    </Tooltip.Provider>
  );
}
